#include <stdlib.h>
#include <SDL/SDL.h>
#include <time.h>
//On veut pouvoir utiliser chdir quelque soit le systme d'exploitation
#if defined WIN32 || defined WIN64 //Windows 32 ou 64 bits
  #include <dir.h>
#else //Le reste du monde... On considre qu'inclure la librairie standard unix suffit
  #include <unistd.h>
#endif

#include "affichage.h"
#include "reseau.h"
#include "jeu.h"

#define SAISIE_MAX 255

void ajouter_latin_1(char *str, long *utile, char lettre, char *accent); //Ajoute un caractre latin-1  la chane
char accentuer(char lettre, char accent); //Renvoie le caractre accentu ou 0 si la combinaison n'est pas gre
long comparer_commande(char *cmd, char *str); //Compare la chane entre  la commande passe en argument
void cmd_lancer(t_affichage *aff, t_reseau *res, t_partie *jeu); //Commande "lancer" : met le serveur en coute
void cmd_map(t_affichage *aff, t_reseau *res, t_partie *jeu, char *arg); //Commande "map" : charge la map spcifie
void cmd_port(t_affichage *aff, t_reseau *res, char *arg); //Commande "port" : change le port d'coute du serveur
void cmd_dist(t_affichage *aff, t_reseau *res, t_partie *jeu, char *arg, long *dist); //Commande pour changer les valeurs de visibilit
void cmd_envoyer_a(t_affichage *aff, t_reseau *res, char *arg); //Commande "envoyer " : envoie un message texte  un joueur
void cmd_pion(t_affichage *aff, t_partie *jeu, char *arg, type_pion pion); //Commande pour changer le nombre de pions de dpart

int main(int argc, char *argv[])
{
    /** Dfinitions des variables **/
    //Variables principales
    SDL_Event event; //Contient l'vnement  traiter
    char buffer[BUFFER_MAX];
    long temps; //Permet de ne pas saturer le processeur
    long continuer; //Vaut Vrai tant que l'on ne dsir pas quitter
    long i, j; //Compteur
    long autokill; //Vaut Vrai si on veut quitter ds que la partie se termine

    //Variables pour la saisie
    char curseur; //Contient le curseur ou un espace (pour le clignotement)
    char saisie[SAISIE_MAX + 1]; //Contient l'entre utilisateur
    long utile; //Taille utile de l'entre
    char accent; //Retient si un accent (circonflxe, trma ou tilde) est entr
    long changer_curseur; //Contient l'heure  laquelle on a changer le curseur (pour le clignotement)
    long focus; //Doit-on afficher le curseur pour la saisie

    //Variables pour l'affichage
    t_affichage console; //Sert pour un affichage style console

    //Variables pour le rseau
    t_reseau serv; //Structure pour les donnes rseau du serveur

    //Variables pour le jeu
    t_partie partie;
    /** Fin des dfinitions **/

    /** Dfinition  du dossier en cours **/
    #if !defined WIN32 && !defined WIN64
    if(argc >= 1) //Si on a le nom du programme
    {
        strcpy(saisie, argv[0]);
        i = strlen(saisie);
        while((i > 0) && (saisie[i] != '\\') && (saisie[i] != '/')) {i--;} //On recherche le nom du dossier d'excution
        saisie[i] = 0; //On enlve le nom du programme
        chdir(saisie); //On se place dans le dossier d'excution
        saisie[0] = 0;
    }
    #endif
    /** Fin **/

    /** Mise en place **/
    if(!aff_init(&console)) {return EXIT_FAILURE;} //Initialisation de l'affichage "console"
    if(!res_init(&serv)) {return EXIT_FAILURE;} //Initialisation des variables pour le rseau
    if(!jeu_init(&partie)) {return EXIT_FAILURE;} //Initialisation des variables pour une partie
    SDL_EnableUNICODE(1); //Permet d'avoir une traduction unicode pour les touches de clavier
    SDL_EnableKeyRepeat(200, 50); //Active la rptition des touches quand on reste appuy au bout de 200 ms puis toutes les 50 ms
    /** Fin de la mise en place **/

    /** Initialisation des variables **/
    srand(time(NULL));
    saisie[0] = 0;
    utile = 0;
    accent = 0;
    curseur = ' ';
    changer_curseur = SDL_GetTicks();
    focus = 1;
    autokill = 0;
    continuer = 1;
    /** Fin d'initialisation des variables **/

    /** Interprtation des arguments d'appelles **/
    for(i = 1; i < argc; i++)
    {
        if(comparer_commande("-lancer", argv[i])) {cmd_lancer(&console, &serv, &partie);
        SDL_WM_IconifyWindow();} //Si on demande de lancer le serveur
        else if(comparer_commande("-map=", argv[i])) //Si on demande de charger la map
        {
            strcpy(saisie, "map = ");
            strcat(saisie, argv[i] + strlen("-map="));
            cmd_map(&console, &serv, &partie, saisie);
        }
        else if(comparer_commande("-port=", argv[i])) //Si on demande de changer le port
        {
            strcpy(saisie, "port = ");
            strcat(saisie, argv[i] + strlen("-port="));
            cmd_port(&console, &serv, saisie);
        }
        else if(comparer_commande("-dist_inc=", argv[i])) //Si on demande de changer la dcouverte du terrain
        {
            strcpy(saisie, "dist_inc = ");
            strcat(saisie, argv[i] + strlen("-dist_inc="));
            cmd_dist(&console, &serv, &partie, saisie, &(partie.dist_inc));
        }
        else if(comparer_commande("-dist_vis=", argv[i])) //Si on demande de changer la visibilit
        {
            strcpy(saisie, "dist_vis = ");
            strcat(saisie, argv[i] + strlen("-dist_vis="));
            cmd_dist(&console, &serv, &partie, saisie, &(partie.dist_vis));
        }
        else if(comparer_commande("-chevalier=", argv[i])) //Si on demande de changer le nombre de chevaliers
        {
            afficher_message(console.ecran, argv[i], console.police_normale, 255, 255, 255);
            strcpy(saisie, argv[i] + strlen("-chevalier="));
            cmd_pion(&console, &partie, saisie, CHEVALIER);
        }
        else if(comparer_commande("-pecore=", argv[i])) //Si on demande de changer le nombre de pcores
        {
            afficher_message(console.ecran, argv[i], console.police_normale, 255, 255, 255);
            strcpy(saisie, argv[i] + strlen("-pecore="));
            cmd_pion(&console, &partie, saisie, PECORE);
        }
        else if(comparer_commande("-eclaireur=", argv[i])) //Si on demande de changer le nombre d'claireurs
        {
            afficher_message(console.ecran, argv[i], console.police_normale, 255, 255, 255);
            strcpy(saisie, argv[i] + strlen("-eclaireur="));
            cmd_pion(&console, &partie, saisie, ECLAIREUR);
        }
        else if(comparer_commande("-charger=", argv[i])) //Si on demande de changer le nombre de chevaliers
        {
            charger(&console, &serv, &partie, argv[i] + strlen("-charger="));
        }
        else if(comparer_commande("-autokill", argv[i])) {autokill = 1;}//Si on demande de quitter  la fin de la partie
        else //Si aucune commande ne correspond
        {
            afficher_message(console.ecran, argv[i], console.police_normale, 255, 0, 255);
            afficher_message(console.ecran, "Argument non reconnu !", console.police_normale, 255, 0, 0);
        }
        saisie[0] = 0;
    }
    /** Fin de l'interprtation **/

    /** Boucle principale **/
    while (continuer) //Tant qu'on ne veut pas quitter
    {
        if(SDL_PollEvent(&event)) //S'il y a quelque chose  faire
        {
            switch(event.type)
            {
                case SDL_QUIT: //Croix de la fentre
                    continuer = 0;
                    break;

                case SDL_KEYDOWN: //Touche prsse
                    switch (event.key.keysym.sym)
                    {
                        case SDLK_ESCAPE: //Si c'est la touche [chap]
                            continuer = 0; //On quitte
                            break;
                        case SDLK_RETURN: //Si c'est la touche [Entre]
                            afficher_message(console.ecran, saisie, console.police_normale, 255, 255, 255); //On "met" la saisie dans la console
                            if(comparer_commande("lancer", saisie)) {cmd_lancer(&console, &serv, &partie);} //Si on demande de lancer le serveur
                            else if(comparer_commande("envoyer ", saisie)) {cmd_envoyer_a(&console, &serv, saisie);} //Si on veut envoyer un message
                            else if(comparer_commande("map", saisie)) {cmd_map(&console, &serv, &partie, saisie);} //Si on demande de charger une map
                            else if(comparer_commande("charger = ", saisie)) {charger(&console, &serv, &partie, saisie + strlen("charger = "));} //Si on demande de charger une partie
                            else if(comparer_commande("port", saisie)) {cmd_port(&console, &serv, saisie);} //Si on demande de changer le port
                            else if(comparer_commande("dist_inc = ", saisie)) {cmd_dist(&console, &serv, &partie, saisie, &(partie.dist_inc));} //Si on demande de changer la distance de dcouverte
                            else if(comparer_commande("dist_vis = ", saisie)) {cmd_dist(&console, &serv, &partie, saisie, &(partie.dist_vis));} //Si on demande de changer la visibilit
                            else if(comparer_commande("nbr_chevalier = ", saisie)) {cmd_pion(&console, &partie, saisie + strlen("nbr_chevalier = "), CHEVALIER);}
                            else if(comparer_commande("nbr_pcore = ", saisie)) {cmd_pion(&console, &partie, saisie + strlen("nbr_pcore = "), PECORE);}
                            else if(comparer_commande("nbr_claireur = ", saisie)) {cmd_pion(&console, &partie, saisie + strlen("nbr_claireur = "), ECLAIREUR);}
                            else if(comparer_commande("aide", saisie)) {afficher_menu(console.ecran, console.police_normale);}//Si on demande la liste des commandes
                            else if(comparer_commande("quitter", saisie)) {continuer = 0;} //Si on demande de quitter
                            else {afficher_message(console.ecran, "Commande non reconnue !", console.police_normale, 255, 0, 0);} //Si aucune commande ne correspond
                            utile = 0; //Nouvelle saisie
                            break;
                        case SDLK_BACKSPACE: //Si c'est la touche [Effacer]
                            if(utile > 0) {utile--;} //On efface le dernier caractre (si possible)
                            break;
                        default: //Dans les autres cas, on vrifie si on a un caractre latin-1 que l'on ajoute  la chane
                            if(((event.key.keysym.unicode & 0xff00) == 0x00) && (event.key.keysym.unicode != 0) && !(event.key.keysym.mod & (KMOD_LCTRL|KMOD_RCTRL))) {ajouter_latin_1(saisie, &utile, event.key.keysym.unicode, &accent);}
                            break;
                    }
                    break;

                case SDL_ACTIVEEVENT:
                    if(event.active.state & SDL_APPINPUTFOCUS) {focus = event.active.gain;} //On affichera le curseur seulement si on a le focus du clavier
                    break;

                default: //Dans tous les autres cas, on ne fait rien
                    break;
            }
        }
        else //Sinon il n'y a rien  faire : on s'occupe du rseau et de l'affichage
        {
            //Rseau
            if(serv.ecoute) //Si le serveur est en coute
            {
                if(partie.jeu == 1) //Si la partie est en cours
                {
                    //Dconnexions intempestives
                    if(serv.nbr_clients < serv.nbr_joueurs)
                    {
                        partie.jeu = 2; //Mise en pause
                        afficher_message(console.ecran, "Partie mise en pause !", console.police_normale, 255, 255, 0);
                    }
                }
                else if(partie.jeu == -1) //Si la partie est termine
                {
                    afficher_message(console.ecran, "Partie termine !", console.police_normale, 0, 255, 0);
                    partie.jeu = -2; //Attente de la dconnexion de tous les joueurs
                }
                else if(partie.jeu == -2)//Si la partie est termine on attend que tout le monde se dconnecte pour arrter l'coute (et le programme si demand)
                {
                    if(serv.nbr_clients == 0)
                    {
                        partie.jeu = 0;
                        if(autokill) {continuer = 0;}
                    }
                }
                else if(partie.jeu == 0 || partie.jeu == 2)//Si le jeu n'est pas en cours ou en pause car dconnexion
                {
                    if(partie.jeu == 2) //Si pause car dconnexion
                    {
                        if(serv.nbr_clients == 0) //et tous les clients dconnects
                        {
                            sauvegarder(&console, &serv, &partie, "autosave.kjeu"); //On assure le coup en faisant une sauvegarde de scurit
                            partie.jeu = 0;
                            if(autokill) {continuer = 0;}
                        }
                        else
                        {
                            //On vrifie s'il y a suffisament de joueurs pour relancer la partie
                            partie.jeu = 1;
                            for(i = 0; i < serv.nbr_joueurs; i++) {if(!serv.joueurs[i].pret) {partie.jeu = 2;}}
                        }
                    }
                    else //Si la partie n'a pas encore commence
                    {
                        //On vrifie s'il y a suffisament de joueurs pour lancer la partie
                        partie.jeu = 1;
                        for(i = 0; i < serv.nbr_joueurs; i++) {if(!serv.joueurs[i].pret) {partie.jeu = 0;}}
                    }
                    if(partie.jeu == 1)
                    {
                        SDL_Delay(50); //Petite pause pour que le dernier client finisse son chargement sans recevoir de message (inutile mais plus propre que d'en demander trop au client)
                        if(serv.chargee != 1) //Si on commence une nouvelle partie
                        {
                            partie.tour = 1; //On commence par le premier joueur
                            partie.deplacement = 0;
                            recharger_pts(partie.pions, partie.nbr_pions, partie.tour);
                            serv.chargee = 1;
                        }
                        for(i = 0; i < partie.nbr_pions; i++)
                        {
                            SDLNet_Write32(i, buffer);
                            SDLNet_Write32(partie.pions[i].pts, buffer + 4);
                            for(j = 0; j < serv.nbr_joueurs; j++) {communiquer(PTS_MVT, 8, buffer, serv.joueurs[j]);}
                        }
                        SDLNet_Write32(partie.tour, buffer);
                        for(i = 0; i < serv.nbr_joueurs; i++) {communiquer(TOUR, 4, buffer, serv.joueurs[i]);}
                        if(serv.joueurs[partie.tour - 1].campeur == 0) {test_campeur(&serv, &partie, partie.tour);}
                        afficher_message(console.ecran, "La partie commence !", console.police_normale, 0, 255, 0);
                    }
                }
                if(!nouveaux_joueurs(&serv, &console)) {return EXIT_FAILURE;} //Si une erreur est survenue, on quitte
                traiter_paquets(&console, &serv, &partie);
            }

            //Affichage
            temps = SDL_GetTicks();
            //On alterne visibilit/invisibilit du curseur toutes les demi-secondes et si on a le focus clavier
            if(focus)
            {
                if((temps - changer_curseur) >= 500)
                {
                    if(curseur == ' ') {curseur = '|';}
                    else {curseur = ' ';}
                    changer_curseur = temps;
                }
                saisie[utile] = curseur;
                saisie[utile + 1] = 0;
            }
            else
            {
                saisie[utile] = ' ';
                saisie[utile + 1] = 0;
            }
            afficher_saisie(console.ecran, saisie, console.police_normale);
            saisie[utile] = 0;

            if(temps - console.dernier_affichage < 40) {SDL_Delay(40 - (temps - console.dernier_affichage));} //On attend (pour ne pas surcharger le processeur) maximum 40 ms (-> 25 fps maximum)
            console.dernier_affichage = temps;
            SDL_Flip(console.ecran); //Puis on effectue la mise  jour de l'affichage
        }
    }
    /** Fin de la boucle principale **/

    /** Grand nettoyage ! **/
    jeu_quit(&serv, &partie);
    res_quit(&serv);
    aff_quit(&console);
    /** Fin du nettoyage **/

    return EXIT_SUCCESS;
}

void ajouter_latin_1(char *str, long *utile, char lettre, char *accent)
{
    if(*utile < SAISIE_MAX - 1) //On vrifie si l'entre est un caractre latin-1
    {
        if(*accent) //S'il y a un accent
        {
            str[*utile] = accentuer(lettre, *accent); //On essaye d'accentuer la lettre
            if(str[*utile] == 0) //Si a marche pas
            {
                str[*utile] = *accent; //On place l'accent qui tait retenu
                if(*utile < SAISIE_MAX - 2)
                {
                    (*utile)++;
                    str[*utile] = lettre; //Et on ajoute le nouveau caractre entr
                }
            }
            *accent = 0;
            (*utile)++;
        }
        else
        {
            if((lettre == '^') || (lettre == '') || (lettre == '~')) {*accent = lettre;} //Si c'est un accent on le retient
            else
            {
                str[*utile] = lettre; //Sinon on ajoute le caractre
                (*utile)++;
            }
        }
    }
    return;
}

char accentuer(char lettre, char accent)
{
    //Tableaux constants contenant des lettres pouvant tre accentues
    const char voyelle[] = {'A', 'E', 'I', 'O', 'U', 'a', 'e', 'i', 'o', 'u', 'y'};
    const char circonflexe[] = {'', '', '', '', '', '', '', '', '', ''};
    const char trema[] = {'', '', '', '', '', '', '', '', '', '', ''};
    long i; //Compteur qui parcourt ces tableaux

    for(i = 0; i < sizeof(voyelle); i++) //Pour chaque lettre pouvant tre accentue
    {
        if(lettre == voyelle[i]) //Si la lettre  traiter est une lettre pouvant tre accentue
        {
            if(accent == '^' && i < sizeof(circonflexe)) {return circonflexe[i];} //Si l'accent voulu est circonflexe et qu'il existe une variante circonflexe de cette lettre, on renvoie la lettre avec l'accent circonflexe
            else if(accent == '' && i < sizeof(trema)) {return trema[i];} //Idem avec le trma
        }
    }
    //Cas particulier du tilde
    if(accent == '~' && lettre == 'N') {return '';}
    else if(accent == '~' && lettre == 'n') {return '';}
    //Sinon on ne peut pas combiner l'accent et la lettre
    return 0;
}

long comparer_commande(char *cmd, char *str)
{
    long i; //Compteur pour la boucle

    if(strlen(cmd) > strlen(str)) {return 0;} //Si la commande est plus longue que la saisie alors ce n'est pas cette commande qui est appele
    else
    {
        //Pour chaque caractre de la commande
        i = 0;
        while(cmd[i] != 0)
        {
            if(cmd[i] != str[i]) {return 0;} //S'il diffre de la saisie alors ce n'est pas cette commande qui est appele
            else i++;
        }
        return 1; //Si tous les caractres sont identiques, on a trouv la commande appele
    }
}

void cmd_lancer(t_affichage *aff, t_reseau *res, t_partie *jeu)
{
    char buffer[SAISIE_MAX + 1];

    if(jeu->map_chargee) //Si on a charge une map
    {
        if(res->ecoute == 0) //Si le serveur n'tait pas en coute
        {
            if(!res->chargee) //Si la partie est nouvelle
            {
                if(!initialiser_pions(res, jeu))
                {
                    afficher_message(aff->ecran, "Impossible de placer tous les pions !", aff->police_normale, 255, 0, 0);
                    return;
                }
            }
            if(lancer_serveur(&(res->serveur), &(res->adresse_serveur), res->port)) //On lance l'coute
            {
                sprintf(buffer, "Serveur en coute sur le port %ld (Attente de %ld joueurs)...", res->port, res->nbr_joueurs);
                afficher_message(aff->ecran, buffer, aff->police_normale, 0, 255, 0);
                res->ecoute = 1;
                res->nbr_clients = 0;
            }
            else {afficher_message(aff->ecran, "Impossible de mettre le serveur en coute !", aff->police_normale, 255, 0, 0);}
        }
        else {afficher_message(aff->ecran, "Le serveur est dj lanc !", aff->police_normale, 255, 0, 0);}
    }
    else {afficher_message(aff->ecran, "Veuillez d'abord charger une map !", aff->police_normale, 255, 0, 0);}
    return;
}

/*void cmd_stop(t_affichage *aff, t_reseau *res)
//Obsolte...
{
    long i; //Compteur

    if(res->ecoute) //Si le serveur est en coute
    {
        for(i = 0; i < res->nbr_joueurs; i++) {supprimer_joueur(res, i);} //On dconnecte chaque client
        SDLNet_TCP_Close(res->serveur); //On arrte l'coute
        res->ecoute = 0;
        res->nbr_clients = 0;
        afficher_message(aff->ecran, "Serveur arrt !", aff->police_normale, 0, 255, 0);
    }
    else {afficher_message(aff->ecran, "Le serveur n'est pas lanc !", aff->police_normale, 255, 0, 0);}
    return;
}*/

void cmd_map(t_affichage *aff, t_reseau *res, t_partie *jeu, char *arg)
{
    arg += strlen("map");
    if(res->ecoute) {afficher_message(aff->ecran, "Impossible de changer la map si le serveur est dj en coute !", aff->police_normale, 255, 0, 0);} //Si dj en coute
    else if(comparer_commande(" = ", arg)) //Si la syntaxe est respecte
    {
        arg += strlen(" = "); //arg contient le nom de la map
        if(jeu->map_chargee) //Libration de la map charge prcdemment
        {
            supprimer_map(res, &(jeu->map));
            jeu->map_chargee = 0;
        }
        if(charger_map(res, &(jeu->map), arg, NULL))
        {
            jeu->map_chargee = 1;
            afficher_message(aff->ecran, "Map charge !", aff->police_normale, 0, 255, 0);
        }
        else{afficher_message(aff->ecran, "Impossible de charger ce fichier !", aff->police_normale, 255, 0, 0);}
    }
    else {afficher_message(aff->ecran, "Erreur de syntaxe !", aff->police_normale, 255, 0, 0);}
    return;
}

void cmd_port(t_affichage *aff, t_reseau *res, char *arg)
{
    char buffer[SAISIE_MAX + 1]; //Sert de tampon pour les textes formats

    arg += strlen("port");
    if(res->ecoute) {afficher_message(aff->ecran, "Impossible de changer le port si le serveur est dj en coute !", aff->police_normale, 255, 0, 0);} //Si dj en coute
    else if(sscanf(arg, " = %ld", &(res->port)) == 1) //S'il y a bien 1 argument d'appel
    {
        if(res->port > 0)
        {
            sprintf(buffer, "Le port  t chang en %ld.", res->port);
            afficher_message(aff->ecran, buffer, aff->police_normale, 0, 255, 0);
        }
        else
        {
            res->port = PORT;
            sprintf(buffer, "Port non valide : remis  sa valeur pas dfaut (%ld) !", res->port);
            afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
        }
    }
    else
    {
        res->port = PORT;
        sprintf(buffer, "Erreur de syntaxe : port remis  sa valeur pas dfaut (%ld) !", res->port);
        afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
    }
    return;
}

void cmd_dist(t_affichage *aff, t_reseau *res, t_partie *jeu, char *arg, long *dist)
{
    long temp, ok;

    if(res->ecoute == 0)
    {
        temp = *dist;
        ok = sscanf(arg + strlen("dist_inc = "), "%ld", dist); //strlen("dist_inc = ") == strlen("dist_vis = ")
        if(*dist <= 0 || !ok)
        {
            afficher_message(aff->ecran, arg, aff->police_normale, 255, 0, 255);
            afficher_message(aff->ecran, "Erreur !", aff->police_normale, 255, 0, 0);
            *dist = temp;
        }
        else {afficher_message(aff->ecran, arg, aff->police_normale, 0, 255, 0);} //Si tout c'est bien pass on affiche une confirmation
        return;
    }
    else {afficher_message(aff->ecran, "Vous ne pouvez pas changer ce paramtres en plein jeu !", aff->police_normale, 255, 0, 0);}
}

void cmd_envoyer_a(t_affichage *aff, t_reseau *res, char *arg)
{
    long i; //Compteur
    char buffer[SAISIE_MAX + 1]; //Sert de tampon pour les textes formats

    arg += strlen("envoyer ");
    if(comparer_commande(" tous : ", arg)) //Si les destinataires sont tous les joueurs
    {
        arg += strlen(" tous : ");
        for(i = 0; i < res->nbr_joueurs; i++) //Pour chaque place de joueur
        {
            if(res->joueurs[i].ecoute == 1) //Si un joueur est connect
            {
                SDLNet_Write32(0, buffer);
                sprintf(buffer + 4, "%s", arg);
                communiquer(MESSAGE, strlen(arg) + 5, buffer, res->joueurs[i]); //On envoie le message au joueur
                sprintf(buffer, "S => n%ld : %s", i + 1, arg);
                afficher_message(aff->ecran, buffer, aff->police_normale, 100, 100, 255);
            }
            else
            {
                sprintf(buffer, "Le joueur n%ld n'est pas connect.", i + 1);
                afficher_message(aff->ecran, buffer, aff->police_normale, 255, 128, 0);
            }
        }
    }
    else if(comparer_commande(" n", arg))
    {
        arg += strlen(" n");
        if(sscanf(arg, "%ld : %c", &i, buffer) != 2) {afficher_message(aff->ecran, "Erreur de syntaxe !", aff->police_normale, 255, 0, 0); return;} //S'il n'y a pas 2 arguments dans la commande
        sprintf(buffer, "%ld : ", i);
        arg += strlen(buffer); //arg pointe sur le message
        i--; //Le numro du joueur devient l'indince dans le tableau
        if((i < res->nbr_joueurs) && (res->joueurs[i].ecoute == 1)) //Si le joueur est connect
        {
            SDLNet_Write32(0, buffer);
            sprintf(buffer + 4, "%s", arg);
            communiquer(MESSAGE, strlen(arg) + 5, buffer, res->joueurs[i]); //On envoie le message au joueur
            sprintf(buffer, "S => n%ld : %s", i + 1, arg);
            afficher_message(aff->ecran, buffer, aff->police_normale, 100, 100, 255);
        }
        else
        {
            sprintf(buffer, "Le joueur n%ld n'est pas connect !", i + 1);
            afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
        }
    }
    else {afficher_message(aff->ecran, "Erreur de syntaxe !", aff->police_normale, 255, 0, 0);}
    return;
}

void cmd_pion(t_affichage *aff, t_partie *jeu, char *arg, type_pion pion)
{
    long nbr, ok;

    ok = sscanf(arg, "%ld", &nbr);
    if(ok && nbr >= 0)
    {
        jeu->nbr_pions_depart[pion] = nbr;
        afficher_message(aff->ecran, "Modification effectue.", aff->police_normale, 0, 255, 0);
    }
    else {afficher_message(aff->ecran, "Erreur !", aff->police_normale, 255, 0, 0);}
}
